setwd("D:/experiment/Conference Paper/ICLR/ICLR 2025/code/table3")
rm(list = ls())
library(MASS)

library(gtools)

dpath          <- file.path("D:/experiment/Conference Paper/ICLR/ICLR 2025/Dataset/")  

d_index <- 5

Dataset       <- c("ailerons_all","bank_all","elevators_all","parkinsons","cpusmall","calhousing") 

savepath      <- paste0("D:/experiment/Conference Paper/ICLR/ICLR 2025/Result/",
                        paste0("Alg2-",Dataset[d_index],".txt"))

traindatapath    <- file.path(dpath, paste0(Dataset[d_index], ".train"))                
traindatamatrix  <- as.matrix(read.table(traindatapath))
trdata           <- traindatamatrix[ ,-1]
ylabel           <- traindatamatrix[ ,1]

length_tr        <- nrow(trdata)    
feature_tr       <- ncol(trdata)  

reptimes <- 3
b        <- 2
U        <- 2
q_1      <- 2/((feature_tr-b)*(feature_tr-b-1))
q_2      <- 2/(feature_tr-b)
q_3      <- 2/(feature_tr*(feature_tr-1))
c        <- 0.005                               ### 0.05,0.1,0.5,1,4,8,16

runtime   <- c(rep(0, reptimes))
errorrate <- c(rep(0, reptimes))

for(re in 1:reptimes)
{
  order    <- sample(1:length_tr,length_tr,replace = F)   #dis
  q        <- c(rep(1/(feature_tr-b), feature_tr-b))
  q_       <- c(rep(1/(feature_tr-b-1), feature_tr-b-1))
  delta_t  <- c(rep(0, feature_tr))
  w        <- c(rep(0, feature_tr))
  h        <- c(rep(0, feature_tr))
  error    <- 0
  
  t1    <- proc.time()                                     #proc.time()
  
  for (t in 1:length_tr)
  {
    lambda        <- c*sqrt(t)/q_3
    Norm          <- sqrt(crossprod(h,h)[1,1])
    w             <- -h/(max(lambda,U*Norm))
    X_t           <- matrix(0,nrow = feature_tr,ncol=feature_tr)
    
    abs_w  <- abs(w)
    lar_elements <- rev(order(abs_w))[1:b]
    subset <- setdiff(1:feature_tr,lar_elements)
    J1     <- sample(subset, 1, replace=T,prob=q)
    subset <- setdiff(subset,J1)   
    J2     <- sample(subset, 1, replace=T,prob=q_)
    
    sum    <- crossprod(w[lar_elements],trdata[order[t],lar_elements])[1,1]
    error  <- error + (sum-ylabel[order[t]])^2
    
    tilde_x    <- delta_t
    for(i in lar_elements)
    {
      tilde_x[i] <- trdata[order[t],i]
      X_t[i,i]   <- trdata[order[t],i]^2
      for(j in setdiff(lar_elements,i))
      {
        X_t[i,j]  <- trdata[order[t],i]*trdata[order[t],j]
      }
      for(j in c(J1,J2))
      {
        X_t[i,j]  <- trdata[order[t],i]*trdata[order[t],j]/q_2
        X_t[j,i]  <- X_t[i,j]
      }
    }
    
    X_t[J1,J1]  <- trdata[order[t],J1]^2/q_2
    X_t[J2,J2]  <- trdata[order[t],J2]^2/q_2
    X_t[J1,J2]  <- trdata[order[t],J1]*trdata[order[t],J2]/q_1
    X_t[J2,J1]  <- X_t[J1,J2]
    

    tilde_x[J1] <- trdata[order[t],J1]/q_2
    tilde_x[J2] <- trdata[order[t],J2]/q_2
    
    ################################## updating w
    tem           <- X_t %*% w
    nabla         <- 2*tem-2*ylabel[order[t]]*tilde_x
    h             <- h + nabla
  }
  
  t2 <- proc.time()
  runtime[re] <- (t2 - t1)[3]
  errorrate[re] <- error/length_tr
}

save_result <- list(
  note     = c(" the next term are:alg_name--dataname--run_time--tot_run_time--ave_run_time--err_num--all_err_rate--ave_err_rate--sd_time--sd_err"),
  alg_name = c("Alg2"),
  dataname = paste0(Dataset[d_index], ".train"),
  sam_num  = length_tr,
  U        = U,
  lambda = c,
  tot_run_time = sum(runtime),
  ave_run_time = sum(runtime)/reptimes,
  err_num  = errorrate,
  ave_err_rate = sum(errorrate)/reptimes,
  sd_time  <- sd(runtime),
  sd_err    <-sd(errorrate)
)
write.table(save_result,file=savepath,row.names =TRUE, col.names =FALSE, quote = T)

sprintf("the number of sample is %d", length_tr)
sprintf("total running time is %.1f in dataset", sum(runtime))
sprintf("average running time is %.1f in dataset", sum(runtime)/reptimes)
sprintf("the average MSE is %f", sum(errorrate)/reptimes)
sprintf("standard deviation of run_time is %.5f in dataset", sd(runtime))
sprintf("standard deviation of MSE is %.5f in dataset", sd(errorrate))
